<?php
/**
 * Plugin Name: AI Contact Form
 * Description: Контактна форма з шорткодом [aicontactform].
 * Version: 1.5.3
 * Author: Slava Sheketa
 */

function aicontactform_shortcode() {
    ob_start();

    $name_label = 'Ім’я';
    $phone_label = 'Телефон';
    $submit_button = 'ОТРИМАТИ ПРОРАХУНОК';

    // JS: динамическая подгрузка стилей и скрытие чекбоксов
    echo '<script>
    document.addEventListener("DOMContentLoaded", function () {
        const form = document.querySelector(".aicontactform");
        if (!form) return;

        const isQuiz = form.closest(".quiz-contact-form");
        const isII = form.closest(".ii");

        if (isQuiz) {
            const checkboxesBlock = form.querySelector(".aicontactform-checkboxes");
            if (checkboxesBlock) {
                checkboxesBlock.style.display = "none";
                const label = checkboxesBlock.previousElementSibling;
                if (label?.tagName === "LABEL") label.style.display = "none";
            }
        }

        const link = document.createElement("link");
        link.rel = "stylesheet";
        link.type = "text/css";
        link.href = isQuiz
            ? "' . plugin_dir_url(__FILE__) . 'aicontactform2.css"
            : isII
            ? "' . plugin_dir_url(__FILE__) . 'aicontactform.css"
            : "";
        if (link.href) document.head.appendChild(link);
    });
    </script>';
    ?>

    <form class="aicontactform" action="<?php echo plugin_dir_url(__FILE__); ?>process-form.php" method="post" novalidate autocomplete="on">
        <input type="hidden" name="product-name" id="product-name-field">
        <input type="hidden" name="page-url" id="page-url-field">

        <!-- 🆕 Скрытые поля для квиза -->
        <input type="hidden" name="monument-type" id="monument-type-field">
        <input type="hidden" name="flower-bed" id="flower-bed-field">
        <input type="hidden" name="installation" id="installation-field">
        <input type="hidden" name="budget" id="budget-field">

        <div class="aicontactform-group">
            <input type="text" name="your-name" id="aicontact-name" placeholder="<?php echo esc_attr($name_label); ?>" required autocomplete="name">
            <small id="name-error" style="color: red; display: none;">Будь ласка, введіть ваше ім’я.</small>
        </div>

        <div class="aicontactform-group">
            <input type="tel" name="your-phone" id="aicontact-phone" placeholder="<?php echo esc_attr($phone_label); ?>" required autocomplete="tel">
            <small id="phone-error" style="color: red; display: none;">Будь ласка, введіть коректний номер телефону.</small>
        </div>

        <label style="display: block; font-weight: bold; margin-bottom: 8px; font-size: 18px;">Параметри пам’ятника:</label>
        <div class="aicontactform-checkboxes">
            <label><input type="checkbox" name="Option[]" value="Ординарний"> Одинарний</label>
            <label><input type="checkbox" name="Option[]" value="Подвійний"> Подвійний</label>
            <label><input type="checkbox" name="Option[]" value="Ексклюзивний"> Ексклюзивний</label>
        </div>

        <div class="aicontactform-group">
            <input type="submit" value="<?php echo esc_attr($submit_button); ?>" autocomplete="off">
        </div>
    </form>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('.aicontactform');
        if (!form) return;

        const nameInput = document.getElementById('aicontact-name');
        const phoneInput = document.getElementById('aicontact-phone');
        const nameError = document.getElementById('name-error');
        const phoneError = document.getElementById('phone-error');
        const pageUrlField = document.getElementById('page-url-field');

        if (pageUrlField) pageUrlField.value = window.location.href;

        phoneInput.addEventListener('input', function() {
            this.value = this.value.replace(/\D/g, '');
        });

        [nameInput, phoneInput].forEach(function(input) {
            input.addEventListener('input', function() {
                input.classList.remove('error');
                if (input === nameInput) nameError.style.display = 'none';
                if (input === phoneInput) phoneError.style.display = 'none';
            });
        });

        form.addEventListener('submit', function(e) {
            let hasError = false;
            let firstErrorField = null;

            if (nameInput.value.trim() === '') {
                nameInput.classList.add('error');
                nameError.style.display = 'block';
                firstErrorField = nameInput;
                hasError = true;
            }

            if (phoneInput.value.trim().length < 9) {
                phoneInput.classList.add('error');
                phoneError.style.display = 'block';
                if (!firstErrorField) firstErrorField = phoneInput;
                hasError = true;
            }

            if (hasError) {
                e.preventDefault();
                firstErrorField.focus();
            }

            // 🧠 Добавление значений из квиза
            const getQuizValue = (stepId) => {
                const checked = document.querySelector(`${stepId} input[type="radio"]:checked`);
                if (checked) {
                    const label = document.querySelector(`label[for="${checked.id}"]`);
                    return label ? label.textContent.trim() : checked.value;
                }
                return '—';
            };

            document.getElementById('monument-type-field').value = getQuizValue('#step-1');
            document.getElementById('flower-bed-field').value     = getQuizValue('#step-2');
            document.getElementById('installation-field').value   = getQuizValue('#step-3');
            document.getElementById('budget-field').value         = getQuizValue('#step-4');
        });
    });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('aicontactform', 'aicontactform_shortcode');

function aicontactform2_register_styles() {
    if (!is_admin()) {
        wp_register_style('aicontactform2-frontend-styles', plugin_dir_url(__FILE__) . 'aicontactform2.css', array(), null, 'all');
        wp_register_style('aicontactform1-frontend-styles', plugin_dir_url(__FILE__) . 'aicontactform.css', array(), null, 'all');
    }
}
add_action('wp_enqueue_scripts', 'aicontactform2_register_styles');

function aicontactform_enqueue_styles() {
    if (!is_admin()) {
        wp_enqueue_style(
            'aicontactform-style',
            plugin_dir_url(__FILE__) . 'aicontactform.css',
            array(),
            null,
            'all'
        );
    }
}
add_action('wp_enqueue_scripts', 'aicontactform_enqueue_styles');
?>
