// 🆔 AIC-1207-v1
jQuery(document).ready(function($) {
    // Получаем формы
    var form1 = $('form.aicontactform');
    var form2 = $('form.form-v2');

    // Примерный Ajax-обработчик для формы-2
    form2.on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        var name = $('#aicontact-name-2').val().trim();
        var phone = $('#aicontact-phone-2').val().trim();
        var product = $('#product-name-field-2').val();
        var page = $('#page-url-field-2').val();

        if (name.length === 0 || phone.length < 9) {
            // Форма уже валидируется встроенным JS — можно не дублировать
            return;
        }

        $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: {
                'your-name': name,
                'your-phone': phone,
                'product-name': product,
                'page-url': page
            },
            success: function(response) {
                form.html('<p style="color: green;"><b>✅ Дякуємо! Заявку отримано.</b></p>');
            },
            error: function() {
                form.html('<p style="color: red;"><b>❌ Помилка відправки. Спробуйте ще раз.</b></p>');
            }
        });
    });

    // форма-1 (если надо обработать дополнительно)
    form1.on('submit', function(e) {
        // здесь можно добавить обработку или оставить как есть
    });
});



// 🆔 GRI-2407-v1
document.addEventListener('DOMContentLoaded', function () {
  const form = document.querySelector('.quiz-contact-form form');
  if (!form) return;

  // Добавляем скрытые поля в форму
  const fields = ['monument-type', 'flower-bed', 'installation', 'budget'];
  fields.forEach(id => {
    if (!form.querySelector(`#${id}-field`)) {
      const hiddenInput = document.createElement('input');
      hiddenInput.type = 'hidden';
      hiddenInput.name = id;
      hiddenInput.id = `${id}-field`;
      form.appendChild(hiddenInput);
    }
  });

  // Функция получения выбранного значения по name
  const getSelectedValue = (name) => {
    const selected = document.querySelector(`input[name="${name}"]:checked`);
    return selected ? selected.value : '';
  };

  // Перед отправкой — заполняем скрытые поля
  form.addEventListener('submit', function () {
    document.getElementById('monument-type-field').value = getSelectedValue('monument');
    document.getElementById('flower-bed-field').value = getSelectedValue('flower');
    document.getElementById('installation-field').value = getSelectedValue('installation');
    document.getElementById('budget-field').value = getSelectedValue('budget');
  });
});
