<?php
// Путь к файлу для отладки
$debug_file = __DIR__ . '/debug.log';

// Подключение WordPress
require_once($_SERVER['DOCUMENT_ROOT'] . '/wp-load.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Проверка обязательных полей
    if (empty($_POST['your-name']) || empty($_POST['your-phone'])) {
        exit('Ошибка: ім’я і телефон обовʼязкові.');
    }

    // Очистка и сбор данных
    $name         = sanitize_text_field($_POST['your-name']);
    $phone        = sanitize_text_field($_POST['your-phone']);
    $product_name = isset($_POST['product-name']) ? sanitize_text_field($_POST['product-name']) : '—';
    $page_url     = isset($_POST['page-url']) ? esc_url_raw($_POST['page-url']) : 'Не визначено';

    // Чекбоксы "Option[]" — параметры пам'ятника
    $options = isset($_POST['Option']) && is_array($_POST['Option']) 
        ? implode(', ', array_map('sanitize_text_field', $_POST['Option'])) 
        : '';

    // Параметры квиза
    $monument_type = isset($_POST['monument-type']) ? sanitize_text_field($_POST['monument-type']) : '';
    $flower_bed    = isset($_POST['flower-bed'])    ? sanitize_text_field($_POST['flower-bed'])    : '';
    $installation  = isset($_POST['installation'])  ? sanitize_text_field($_POST['installation'])  : '';
    $budget        = isset($_POST['budget'])        ? sanitize_text_field($_POST['budget'])        : '';

    // Время заявки
    $timestamp = date('d.m.Y H:i');

    // Формируем сообщение
    $text = "<b>✅ Заявка з сайту Granitka</b>\n"
          . "<i>⏰ $timestamp</i>\n\n";

    if (!empty($options))        $text .= "<b>Тип пам’ятника:</b> $options\n";
    if (!empty($monument_type))  $text .= "<b>Вид пам’ятника:</b> $monument_type\n";
    if (!empty($flower_bed))     $text .= "<b>Тип квітника:</b> $flower_bed\n";
    if (!empty($installation))   $text .= "<b>Встановлення:</b> $installation\n";
    if (!empty($budget))         $text .= "<b>Бюджет:</b> $budget\n";

    $text .= "\n<b>Ім’я:</b> $name\n"
          .  "<b>Телефон:</b> $phone";

    // Telegram
    $telegram_token = '8082671839:AAEYz44Q3PC3tkcWde_t9ajxEoh6OugCh50';
    $chat_id        = '-1002779527257';
    $telegram_api   = "https://api.telegram.org/bot$telegram_token/sendMessage";

    $response = wp_remote_get($telegram_api . '?' . http_build_query([
        'chat_id'    => $chat_id,
        'text'       => $text,
        'parse_mode' => 'HTML',
    ]));

    // Лог ошибок
    if (is_wp_error($response)) {
        file_put_contents($debug_file, date('[Y-m-d H:i:s] ') . 'Telegram Error: ' . $response->get_error_message() . PHP_EOL, FILE_APPEND);
    }

    // Перенаправление
    wp_redirect(strpos($page_url, '/ua/') !== false ? home_url('/ua/thank-ua') : home_url('/thank-you2'));
    exit;
}
?>
