<?php
/**
 * The7 theme.
 *
 * @since   1.0.0
 * @package The7
 */

defined('ABSPATH') || exit;

// ✅ Активация темы и регистрация (фиктивный ключ)
update_site_option('the7_registered', 'yes');
update_site_option('the7_purchase_code', 'the7_purchase_code');

// ✅ Подмена источника плагинов на внешнюю ссылку
add_action('tgmpa_register', function () {
    if (isset($GLOBALS['the7_tgmpa'])) {
        $tgmpa_instance = call_user_func([get_class($GLOBALS['the7_tgmpa']), 'get_instance']);
        foreach ($tgmpa_instance->plugins as $slug => $plugin) {
            if ($plugin['source_type'] === 'external') {
                $tgmpa_instance->plugins[$plugin['slug']]['source'] = "http://wordpressnull.org/the7/plugins/{$plugin['slug']}.zip";
                $tgmpa_instance->plugins[$plugin['slug']]['version'] = '';
            }
        }
    }
}, 20);

// ✅ Установка ширины контента
if (!isset($content_width)) {
    $content_width = 1200; // pixels
}

// ✅ Инициализация темы The7
require trailingslashit(get_template_directory()) . 'inc/init.php';

// ✅ Переместить блок артикула выше цены
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 5);

// ✅ Удалить блок шаринга
add_action('wp', function () {
    if (function_exists('is_product') && is_product()) {
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_share', 50);
    }
});

// ✅ Переместить описание категории под список товаров
add_action('woocommerce_before_main_content', function () {
    remove_action('woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10);
    remove_action('woocommerce_archive_description', 'woocommerce_product_archive_description', 10);

    add_action('woocommerce_after_main_content', 'woocommerce_taxonomy_archive_description', 5);
    add_action('woocommerce_after_main_content', 'woocommerce_product_archive_description', 5);
}, 5);

// ✅ Переименование опции сортировки
add_filter('woocommerce_catalog_orderby', function ($options) {
    if (isset($options['menu_order'])) {
        $options['menu_order'] = 'Сортировка';
    }
    return $options;
});

// ✅ Скрипт плавной прокрутки якорей
add_action('wp_footer', function () {
    ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const OFFSET = 100;
            const DURATION = 50;

            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener("click", function (e) {
                    const targetId = this.getAttribute("href").substring(1);
                    const targetEl = document.getElementById(targetId);
                    if (targetEl) {
                        e.preventDefault();
                        const startY = window.pageYOffset;
                        const targetY = targetEl.getBoundingClientRect().top + startY - OFFSET;
                        const startTime = performance.now();

                        function scrollStep(currentTime) {
                            const elapsed = currentTime - startTime;
                            const progress = Math.min(elapsed / DURATION, 1);
                            const easeInOut = progress < 0.5 ? 2 * progress * progress : -1 + (4 - 2 * progress) * progress;
                            window.scrollTo(0, startY + (targetY - startY) * easeInOut);
                            if (elapsed < DURATION) requestAnimationFrame(scrollStep);
                        }
                        requestAnimationFrame(scrollStep);
                    }
                });
            });
        });
    </script>
    <?php
});

// ✅ GRI-0907-v1 — логика переключения шагов квиза без popup
add_action('wp_footer', function () {
    ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const steps = document.querySelectorAll('.quiz-step');
            let current = 0;

            function showStep(index) {
                steps.forEach((step, i) => step.classList.toggle('active', i === index));
            }

            document.querySelectorAll('.next-step').forEach(btn => btn.addEventListener('click', () => {
                const currentStep = steps[current];
                const inputs = currentStep.querySelectorAll('input[type="radio"], input[type="checkbox"]');
                const groupedByName = {};

                inputs.forEach(input => {
                    const name = input.name;
                    if (!groupedByName[name]) groupedByName[name] = [];
                    groupedByName[name].push(input);
                });

                let allValid = true;
                currentStep.querySelectorAll('.quiz-option').forEach(option => option.classList.remove('error'));

                for (let name in groupedByName) {
                    const group = groupedByName[name];
                    const selected = group.some(input => input.checked);
                    if (!selected) {
                        allValid = false;
                        group.forEach(input => {
                            const label = input.closest('.quiz-option');
                            if (label) label.classList.add('error');
                        });
                    }
                }

                if (!allValid) {
                    alert('Будь ласка, оберіть хоча б один варіант перед переходом далі.');
                    return;
                }

                if (current < steps.length - 1) {
                    current++;
                    showStep(current);
                }
            }));

            document.querySelectorAll('.prev-step').forEach(btn => btn.addEventListener('click', () => {
                if (current > 0) {
                    current--;
                    showStep(current);
                }
            }));

            document.querySelectorAll('.quiz-option input[type="radio"], .quiz-option input[type="checkbox"]').forEach(input => {
                input.addEventListener('change', () => {
                    const label = input.closest('.quiz-option');
                    if (label) label.classList.remove('error');
                });
            });
        });
    </script>
    <?php
});

// ✅ GRI-0907-v19 — Прогрессбар для квиза
add_action('wp_footer', function () {
    ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const steps = document.querySelectorAll('.quiz-step');
            const totalSteps = steps.length;

            function updateProgress(currentIndex) {
                document.querySelectorAll('.quiz-progress-fill').forEach((bar, i) => {
                    bar.style.width = (i === currentIndex) ? `${(currentIndex + 1) / totalSteps * 100}%` : '0%';
                });

                document.querySelectorAll('.quiz-progress-text').forEach((text, i) => {
                    text.textContent = `Крок ${i + 1} з ${totalSteps}`;
                });
            }

            updateProgress(0);

            document.querySelectorAll('.next-step, .prev-step').forEach(btn => {
                btn.addEventListener('click', function () {
                    setTimeout(() => {
                        const currentStep = [...steps].findIndex(step => step.classList.contains('active'));
                        updateProgress(currentStep);
                    }, 50);
                });
            });
        });
    </script>
    <?php
});





// ✅ GRI-2107-v6 — Работает и на мобильных: активация вкладки + прокруткаadd_action('wp_footer', function () {
add_action('wp_footer', function () {
    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        const tabInput = document.getElementById("tab4");
        const tabLabel = document.querySelector('label[for="tab4"]');
        const offset = 100;

        function scrollToTab() {
            if (tabInput) tabInput.checked = true;
            if (tabLabel) {
                setTimeout(() => {
                    const y = tabLabel.getBoundingClientRect().top + window.pageYOffset - offset;
                    window.scrollTo({ top: y, behavior: "smooth" });
                }, 100);
            }
        }

        function closeMobileMenu() {
            // Принудительно закрыть мобильное меню (адаптируйте селектор под вашу тему при необходимости)
            const body = document.body;
            if (body.classList.contains("mobile-menu-open")) {
                body.classList.remove("mobile-menu-open");
            }

            // Альтернативный триггер на закрытие меню-кнопки
            const closeBtn = document.querySelector(".dt-mobile-menu-icon.opened");
            if (closeBtn) closeBtn.click();
        }

        // 1. Обработка клика по <p id="zsu-reload-btn">
        const zsuBtn = document.getElementById("zsu-reload-btn");
        if (zsuBtn) {
            zsuBtn.addEventListener("click", function (e) {
                e.preventDefault();
                scrollToTab();
                closeMobileMenu();
            });
        }

        // 2. Обработка <a href="#military-monuments"> в мобильном меню
        document.querySelectorAll('a[href="#military-monuments"]').forEach(link => {
            link.addEventListener("click", function (e) {
                e.preventDefault();
                scrollToTab();
                closeMobileMenu();
            });
        });
    });
    </script>
    <?php
});

// GRI-1907-v10 — вставка Facebook Pixel в <head>
add_action('wp_head', 'insert_facebook_pixel');
function insert_facebook_pixel() {
  ?>
 <!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '677762551297982');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=677762551297982&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
  <?php
}


// ✅ GRI-2407-v9: Подключение скрипта передачи данных из квиза в скрытые поля формы AIContactForm
add_action('wp_footer', function () {
    if (is_page()) { // Можно заменить на is_page('granitka') или нужный ID
        ?>
        <script>
        document.addEventListener("DOMContentLoaded", function () {
          const quizForm = document.querySelector('.quiz-contact-form form');
          if (!quizForm) return;

          const monumentField = quizForm.querySelector('#monument-type-field');
          const flowerBedField = quizForm.querySelector('#flower-bed-field');
          const installationField = quizForm.querySelector('#installation-field');
          const budgetField = quizForm.querySelector('#budget-field');

          function getCheckedValue(name) {
            const checked = document.querySelector(`input[name="${name}"]:checked`);
            return checked ? checked.value : '';
          }

          quizForm.addEventListener('submit', function () {
            if (monumentField) monumentField.value = getCheckedValue('type');
            if (flowerBedField) flowerBedField.value = getCheckedValue('flowerbed');
            if (installationField) installationField.value = getCheckedValue('install');
            if (budgetField) budgetField.value = getCheckedValue('budget');
          });
        });
        </script>
        <?php
    }
});


